<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Project extends Model
{
    use HasTranslations;

    protected $fillable = [
        'title',
        'slug',
        'description',
        'client',
        'duration',
        'technologies',
        'project_url',
        'featured_image',
        'category_id',
        'sector_id',
        'is_featured',
        'order',
        'is_active'
    ];

    public $translatable = ['title', 'description', 'client'];

    protected $casts = [
        'technologies' => 'array',
        'is_featured' => 'boolean',
        'is_active' => 'boolean',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function sector()
    {
        return $this->belongsTo(Sector::class);
    }

    public function images()
    {
        return $this->hasMany(ProjectImage::class);
    }
}
