<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Testimonial extends Model
{
    use HasTranslations;

    protected $fillable = [
        'client_name',
        'client_position',
        'content',
        'avatar',
        'rating',
        'project_id',
        'order',
        'is_active'
    ];

    public $translatable = ['client_name', 'client_position', 'content'];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }
}
