<?php

return [
    // General
    'hello' => 'Hello',
    'i_am' => 'I\'m',
    'name' => 'Bishoy Khalil',
    'role' => 'Technical Lead & Full-Stack Developer',
    'years_experience' => '+13 Years Experience',
    'download_cv' => 'Download CV',
    'view_portfolio' => 'View Portfolio',
    'contact_me' => 'Contact Me',
    'read_more' => 'Read More',
    'all_rights_reserved' => 'All Rights Reserved',
    'developed_by' => 'Developed by',

    // Navigation
    'site_title' => 'Abdullah | Software Developer & Smart Solutions Expert',
    'site_description' => 'Abdullah Portfolio - Expert in web development, mobile apps, and integrated software solutions with experience in digital transformation.',
    'site_keywords' => 'software developer, web development, mobile apps, Abdullah, portfolio, software solutions',
    'nav_home' => 'Home',
    'nav_about' => 'About',
    'nav_services' => 'Services',
    'nav_skills' => 'Skills',
    'nav_experience' => 'Experience',
    'nav_portfolio' => 'Portfolio',
    'nav_sectors' => 'Sectors',
    'nav_testimonials' => 'Testimonials',
    'nav_blog' => 'Blog',
    'nav_contact' => 'Contact',

    // Hero Section
    'hero_subtitle' => 'Hello, I\'m',
    'hero_title_1' => 'Bishoy Khalil',
    'hero_title_2' => 'Technical Lead',
    'hero_title_3' => 'Full-Stack Developer',
    'hero_title_4' => 'GovTech Specialist',
    'hero_description' => 'A results-driven Technical Lead & Senior Full-Stack Developer with over 13 years of experience, now strategically enhancing my technical prowess with formal Digital Marketing. I specialize in building technology solutions that are not only robust and scalable but are also market-oriented, user-focused, and designed for business growth.',
    'hero_btn_portfolio' => 'View My Work',
    'hero_btn_contact' => 'Get In Touch',

    // About Section
    'about_title' => 'About Me',
    'about_subtitle' => 'Get to know me',
    'about_description' => 'A results-driven Technical Lead & Senior Full-Stack Developer with over 13 years of experience building robust, scalable, and market-oriented technology solutions. I uniquely integrate technical expertise with digital marketing to ensure products not only function flawlessly but also grow and compete effectively. I have worked on confidential governmental projects in KSA and Egypt, bridging the gap between technical teams and market needs.',
    'about_experience_years' => 'Years Experience',
    'about_projects_completed' => 'Projects Completed',
    'about_clients_worldwide' => 'Clients Worldwide',

    // Services Section
    'services_title' => 'Services',
    'services_subtitle' => 'What I Offer',
    'service_1_title' => 'Full-Stack Development',
    'service_1_description' => 'Building web applications using modern frameworks (Laravel, .NET Core, React, Angular) with clean, maintainable code.',
    'service_2_title' => 'ERP & HRIS Solutions',
    'service_2_description' => 'Designing and implementing integrated systems for accounts, payroll, HR, inventory, and more, tailored to client needs.',
    'service_3_title' => 'Technical Leadership & Consulting',
    'service_3_description' => 'Leading agile teams, defining project scope, architecting solutions, and ensuring alignment with business goals.',
    'service_4_title' => 'System Integration & APIs',
    'service_4_description' => 'Connecting disparate systems through robust APIs and microservices architecture.',
    'service_5_title' => 'Digital Marketing Strategy for Tech Products',
    'service_5_description' => 'Applying market analysis, user-centric design, and conversion optimization to ensure your product reaches its audience effectively.',
    'service_6_title' => 'Systems Analysis & Consulting',
    'service_6_description' => 'Analyzing existing business processes and providing recommendations for efficiency improvements and cost reduction.',

    // Skills Section
    'skills_title' => 'Skills',
    'skills_subtitle' => 'What I Excel At',
    'skills_technical' => 'Technical Skills',
    'skills_marketing' => 'Marketing & Analysis',
    'skills_soft' => 'Soft Skills',
    'skill_backend' => 'Backend Development',
    'skill_frontend' => 'Frontend Development',
    'skill_databases' => 'Databases',
    'skill_tools' => 'Tools & Methodologies',
    'skill_digital_marketing' => 'Digital Marketing',
    'skill_market_analysis' => 'Market Analysis',
    'skill_seo' => 'SEO Fundamentals',
    'skill_conversion_optimization' => 'Conversion Optimization',
    'skill_communication' => 'Communication',
    'skill_leadership' => 'Leadership',
    'skill_problem_solving' => 'Problem Solving',
    'skill_stakeholder_management' => 'Stakeholder Management',

    // Experience Section
    'experience_title' => 'Experience',
    'experience_subtitle' => 'My Professional Journey',
    'exp_1_position' => 'Technical Lead',
    'exp_1_company' => 'Smartboxuae.ae - Software Solutions',
    'exp_1_location' => 'Dubai, UAE',
    'exp_1_period' => 'Feb 2020 - Present',
    'exp_1_desc_1' => 'Led end-to-end development of the Smartbox platform, applying user-centric design informed by marketing insights to enhance engagement.',
    'exp_1_desc_2' => 'Translated business and market requirements into technical tasks, ensuring product-market fit.',
    'exp_1_desc_3' => 'Planned project blueprints considering time-to-market and competitive landscape.',

    'exp_2_position' => 'Technical Lead',
    'exp_2_company' => 'Edge-SC - Solutions Consultant',
    'exp_2_period' => '2020 - 2022',
    'exp_2_desc_1' => 'Architected software solutions focused on measurable business value and ROI.',
    'exp_2_desc_2' => 'Communicated complex technical concepts to non-technical stakeholders to secure buy-in.',

    'exp_3_position' => 'Technical Lead',
    'exp_3_company' => 'Manara Al-Safya (Governmental Municipality)',
    'exp_3_location' => 'KSA',
    'exp_3_period' => 'Jan 2013 - Jan 2017',
    'exp_3_desc_1' => 'Managed requests for new modules and modifications.',
    'exp_3_desc_2' => 'Drafted analytical reports on user requirements using market-research-like techniques.',
    'exp_3_desc_3' => 'Ensured modules improved internal workflow efficiency, contributing to operational productivity.',

    'exp_4_position' => 'Technical Lead',
    'exp_4_company' => 'Fu-tech (Egypt branch from KSA)',
    'exp_4_period' => 'Oct 2009 - Dec 2013',
    'exp_4_desc_1' => 'Cooperated with designers to create clean interfaces and intuitive interactions.',
    'exp_4_desc_2' => 'Developed project concepts and maintained optimal workflow.',
    'exp_4_desc_3' => 'Conducted quality assurance tests to optimize usability.',

    'exp_5_position' => 'IT and Software Coder',
    'exp_5_company' => 'Anmat Office - Innovation & Excellence',
    'exp_5_location' => 'KSA',
    'exp_5_period' => 'Aug 2006 - Sept 2009',
    'exp_5_desc_1' => 'Coding, debugging, designing, and testing computer structures.',
    'exp_5_desc_2' => 'Analyzed business processes and systems to identify improvement opportunities.',
    'exp_5_desc_3' => 'Designed and implemented ERP and HRIS solutions ensuring alignment with business goals.',

    // Portfolio Section
    'portfolio_title' => 'Portfolio',
    'portfolio_subtitle' => 'Selected Projects',
    'portfolio_all' => 'All',
    'portfolio_erp' => 'ERP',
    'portfolio_government' => 'Government',
    'portfolio_lms' => 'LMS',
    'portfolio_websites' => 'Websites',
    'portfolio_healthcare' => 'Healthcare',
    'portfolio_education' => 'Education',
    'project_1_title' => 'ERP Smart Click',
    'project_1_description' => 'Comprehensive ERP system covering accounts, payroll, sales, warehouse, HR, attendance, and inventory.',
    'project_2_title' => 'Tareeb Municipality Systems (KSA)',
    'project_2_description' => 'Government systems for lands, health, finance, planning, attendance, accounts, projects, communication.',
    'project_3_title' => 'LMS Platform',
    'project_3_description' => 'Learning Management System with users, courses, classes, virtual classes, attendance, surveys, polls, reports, analytics, online payment.',
    'project_4_title' => 'Smartboxuae.ae Platform',
    'project_4_description' => 'A digital platform for gifting services and innovative software solutions.',
    'project_5_title' => 'Medical Lab System (KSA)',
    'project_5_description' => 'Integrated system including accounting, patient files, doctor schedules, procedures, patient history, permissions, reports, insurance.',
    'project_6_title' => 'Dallah Driving School (KSA)',
    'project_6_description' => 'Comprehensive management system for a driving school.',
    'project_7_title' => 'Almajdouie Motors (KSA)',
    'project_7_description' => 'Car service center management system.',
    'project_8_title' => 'Maaref Plug (Noor System)',
    'project_8_description' => 'Integration with Noor platform, Ministry of Education, KSA.',

    // Sectors Section
    'sectors_title' => 'Sectors',
    'sectors_subtitle' => 'Industries I Serve',
    'sector_government' => 'Government',
    'sector_government_desc' => 'Municipality systems, ministries (Education, Environment, Municipal Affairs), governmental projects in KSA and Egypt.',
    'sector_education' => 'Education',
    'sector_education_desc' => 'LMS platforms, integration with Noor system (Ministry of Education, KSA).',
    'sector_healthcare' => 'Healthcare',
    'sector_healthcare_desc' => 'Medical lab systems, clinics, patient management.',
    'sector_logistics' => 'Logistics & Transportation',
    'sector_logistics_desc' => 'Driving schools, car service centers.',
    'sector_ecommerce' => 'E-commerce & Services',
    'sector_ecommerce_desc' => 'Smartboxuae.ae platform, corporate websites.',
    'sector_corporate' => 'Corporate',
    'sector_corporate_desc' => 'ERP, HRIS, accounting, HR solutions.',
    'sector_fintech' => 'FinTech',
    'sector_fintech_desc' => 'Payment gateways, invoicing, accounting systems.',

    // Testimonials Section
    'testimonials_title' => 'Testimonials',
    'testimonials_subtitle' => 'What Clients Say',
    'testimonial_1_text' => 'I worked with Bishoy on several government projects. He showed high efficiency in understanding requirements and transforming them into integrated technical solutions.',
    'testimonial_1_name' => 'Ahmed Al-Sulami',
    'testimonial_1_position' => 'Project Manager - Ministry of Education, KSA',
    'testimonial_2_text' => 'Bishoy has a unique ability to bridge the gap between technology and market needs. He helped us develop our product with a clear marketing vision.',
    'testimonial_2_name' => 'Mohammed Al-Rashed',
    'testimonial_2_position' => 'CEO - Takamul Solutions',
    'testimonial_3_text' => 'Extensive experience in ERP development. He significantly contributed to improving our internal processes efficiency.',
    'testimonial_3_name' => 'Sara Al-Nasser',
    'testimonial_3_position' => 'HR Manager - Almajdouie Motors',

    // Contact Section
    'contact_title' => 'Contact Me',
    'contact_subtitle' => 'Let\'s Work Together',
    'contact_name' => 'Name',
    'contact_email' => 'Email',
    'contact_phone' => 'Phone',
    'contact_subject' => 'Subject',
    'contact_message' => 'Message',
    'contact_send' => 'Send Message',
    'contact_success' => 'Your message has been sent successfully. I will get back to you soon.',
    'contact_fail' => 'An error occurred. Please try again later.',
    'contact_info' => 'Contact Info',
    'contact_address' => 'Dubai, United Arab Emirates',
    'contact_follow' => 'Follow Me',

    // Blog Section
    'blog_title' => 'Blog',
    'blog_subtitle' => 'Latest Articles',
    'blog_1_title' => 'How to Choose the Right Tech Stack for Your Startup?',
    'blog_1_excerpt' => 'Choosing the right technology determines your project\'s success. In this article, I discuss key factors for selecting the right stack...',
    'blog_2_title' => 'The Importance of Bridging Technology and Marketing in Digital Products',
    'blog_2_excerpt' => 'Why do some tech products fail despite their quality? The answer often lies in the lack of integration with marketing strategy...',
    'blog_3_title' => 'My Experience in Government Projects: Challenges and Successes',
    'blog_3_excerpt' => 'Working with the government sector requires flexibility and deep understanding of systems. I share some lessons learned from past projects...',

    // Footer
    'footer_quick_links' => 'Quick Links',
    'footer_contact' => 'Contact Info',
    'footer_newsletter' => 'Newsletter',
    'footer_newsletter_desc' => 'Subscribe to receive latest news and articles.',
    'footer_newsletter_placeholder' => 'Your Email',
    'footer_rights' => 'All Rights Reserved',

    // CV Download
    'cv_file' => 'Bishoy_Khalil_CV.pdf',
];
