@extends('layouts.admin')

@section('title', 'Contact Messages')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Contact Messages</h2>
            </div>
            
            @if(session('success'))
                <div class="alert alert-success mt-3 mb-3">
                    {{ session('success') }}
                </div>
            @endif

            <table class="table table-bordered bg-white">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($messages as $message)
                        <tr class="{{ $message->is_read ? '' : 'table-warning font-weight-bold' }}">
                            <td>{{ $message->created_at->format('Y-m-d H:i') }}</td>
                            <td>{{ $message->name }}</td>
                            <td>{{ $message->email }}</td>
                            <td>
                                @if($message->is_read)
                                    <span class="badge bg-secondary text-white">Read</span>
                                @else
                                    <span class="badge bg-primary text-white">New</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.messages.show', $message) }}" class="btn btn-sm btn-info">View</a>
                                <form action="{{ route('admin.messages.destroy', $message) }}" method="POST" class="d-inline">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center">No messages found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
