@extends('layouts.admin')

@section('title', 'View Message')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="mb-4">
                <a href="{{ route('admin.messages.index') }}" class="btn btn-secondary">Back to Messages</a>
            </div>

            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h5 class="mb-0">Message from {{ $message->name }}</h5>
                    <span>{{ $message->created_at->format('F j, Y, g:i a') }}</span>
                </div>
                <div class="card-body">
                    <p><strong>Email:</strong> {{ $message->email }}</p>
                    <hr>
                    <p><strong>Message:</strong></p>
                    <div class="p-3 bg-light border rounded">
                        {!! nl2br(e($message->message)) !!}
                    </div>
                </div>
                <div class="card-footer">
                    <form action="{{ route('admin.messages.destroy', $message) }}" method="POST" class="d-inline">
                        @csrf @method('DELETE')
                        <button class="btn btn-danger" onclick="return confirm('Are you sure?')">Delete Message</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
