@extends('layouts.admin')

@section('title', 'Create Project')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <span>Create New Project</span>
                    <a href="{{ route('admin.projects.index') }}" class="btn btn-sm btn-secondary">Back</a>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ route('admin.projects.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="row">
                            <!-- English Title -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title (English)</label>
                                <input type="text" name="title[en]" class="form-control" required>
                            </div>
                            <!-- Arabic Title -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title (Arabic)</label>
                                <input type="text" name="title[ar]" class="form-control" dir="rtl" required>
                            </div>
                        </div>

                        <div class="row">
                            <!-- English Client -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Client (English)</label>
                                <input type="text" name="client[en]" class="form-control">
                            </div>
                            <!-- Arabic Client -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Client (Arabic)</label>
                                <input type="text" name="client[ar]" class="form-control" dir="rtl">
                            </div>
                        </div>

                        <!-- English Description -->
                        <div class="mb-3">
                            <label class="form-label">Description (English)</label>
                            <textarea name="description[en]" class="form-control" rows="4" required></textarea>
                        </div>

                        <!-- Arabic Description -->
                        <div class="mb-3">
                            <label class="form-label">Description (Arabic)</label>
                            <textarea name="description[ar]" class="form-control" rows="4" dir="rtl" required></textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Duration</label>
                                <input type="text" name="duration" class="form-control" placeholder="e.g. 3 Months">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Project URL</label>
                                <input type="url" name="project_url" class="form-control">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            <input type="file" name="featured_image" class="form-control">
                        </div>

                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" name="is_featured" value="1" id="is_featured">
                            <label class="form-check-label" for="is_featured">Featured Project</label>
                        </div>

                        <button type="submit" class="btn btn-primary">Save Project</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
