@extends('layouts.admin')

@section('title', 'Create Service')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <span>Create New Service</span>
                    <a href="{{ route('admin.services.index') }}" class="btn btn-sm btn-secondary">Back</a>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.services.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title (English)</label>
                                <input type="text" name="title[en]" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title (Arabic)</label>
                                <input type="text" name="title[ar]" class="form-control" dir="rtl" required>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description (English)</label>
                            <textarea name="description[en]" class="form-control" rows="4" required></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description (Arabic)</label>
                            <textarea name="description[ar]" class="form-control" rows="4" dir="rtl" required></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Icon Class (FontAwesome)</label>
                            <input type="text" name="icon" class="form-control" placeholder="e.g. fa-light fa-pen-ruler">
                        </div>

                        <button type="submit" class="btn btn-primary">Save Service</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
