@extends('layouts.app')

@section('title', 'Login - Admin Dashboard')

@section('content')
<div class="login-area tmp-section-gap">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-5">
                <div class="login-form-wrapper" style="background: #1b1b1c; padding: 40px; border-radius: 10px; border: 1px solid #ffffff14;">
                    <div class="section-title text-center mb--30">
                        <span class="subtitle">Admin Access</span>
                        <h2 class="title">Login to Dashboard</h2>
                    </div>
                    
                    <form action="{{ route('login.submit') }}" method="POST">
                        @csrf
                        <div class="form-group mb--20">
                            <label style="color: #fff; margin-bottom: 10px; display: block;">Email Address</label>
                            <input type="email" name="email" class="form-control" style="background: #242435; border: 1px solid #ffffff14; color: #fff; padding: 15px;" required value="{{ old('email') }}">
                            @error('email')
                                <span class="text-danger mt-2 d-block">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group mb--20">
                            <label style="color: #fff; margin-bottom: 10px; display: block;">Password</label>
                            <input type="password" name="password" class="form-control" style="background: #242435; border: 1px solid #ffffff14; color: #fff; padding: 15px;" required>
                            @error('password')
                                <span class="text-danger mt-2 d-block">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group mb--30">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember">
                                <label class="form-check-label" for="remember" style="color: #9f9f9f;">
                                    Remember Me
                                </label>
                            </div>
                        </div>

                        <button type="submit" class="tmp-btn w-100" style="padding: 15px; background: var(--color-primary); color: #fff; border: none; border-radius: 5px; font-weight: 600;">Login Now</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .form-control:focus {
        background: #242435 !important;
        border-color: var(--color-primary) !important;
        box-shadow: none !important;
        color: #fff !important;
    }
</style>
@endsection
