<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - @yield('title')</title>
    
    <!-- Bootstrap CSS -->
    @if(app()->getLocale() == 'ar')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    @else
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    @endif
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        body {
            background-color: #13131d;
            color: #dedede;
        }
        .card {
            background-color: #1b1b1c;
            border: 1px solid #ffffff14;
            color: #dedede;
        }
        .card-header {
            border-bottom: 1px solid #ffffff14;
            background-color: rgba(255, 255, 255, 0.05);
        }
        .form-control, .form-select {
            background-color: #242435;
            border: 1px solid #ffffff14;
            color: #fff;
        }
        .form-control:focus {
            background-color: #242435;
            border-color: #ff014f;
            color: #fff;
            box-shadow: none;
        }
        .list-group-item {
            background-color: #1b1b1c;
            border: 1px solid #ffffff14;
            color: #9f9f9f;
        }
        .list-group-item.active {
            background-color: #ff014f;
            border-color: #ff014f;
        }
        .list-group-item:hover {
            background-color: #242435;
            color: #fff;
        }
        .btn-primary {
            background-color: #ff014f;
            border-color: #ff014f;
        }
        .btn-primary:hover {
            background-color: #d10041;
            border-color: #d10041;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
        <div class="container text-center">
            <a class="navbar-brand" href="{{ route('admin.dashboard') }}">Portfolio Admin</a>
            <div class="ms-auto d-flex align-items-center">
                 <form action="{{ route('logout') }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-outline-danger btn-sm">Logout</button>
                </form>
            </div>
        </div>
    </nav>

    <div class="container">
        @if(session('success'))
            <div class="alert alert-success mt-3">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger mt-3">{{ session('error') }}</div>
        @endif
        @yield('content')
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
