<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Dynamic SEO Meta Tags -->
    <title>@yield('title', __('messages.site_title'))</title>
    <meta name="description" content="@yield('meta_description', __('messages.site_description'))">
    <meta name="keywords" content="@yield('meta_keywords', __('messages.site_keywords'))">
    <meta name="author" content="Abdullah">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('assets/images/favicon.svg') }}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="@yield('title', __('messages.site_title'))">
    <meta property="og:description" content="@yield('meta_description', __('messages.site_description'))">
    <meta property="og:image" content="@yield('og_image', asset('assets/images/og-image.jpg'))">

    <!-- Arabic Font (Cairo) -->
    @if(app()->getLocale() == 'ar')
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body, h1, h2, h3, h4, h5, h6, p, span, a, input, textarea, button {
            font-family: 'Cairo', sans-serif !important;
        }
    </style>
    @endif

    <style>
        .custom-cursor {
            width: 20px;
            height: 20px;
            border: 2px solid var(--color-primary, #007bff);
            border-radius: 50%;
            position: fixed;
            pointer-events: none;
            z-index: 9999;
            transform: translate(-50%, -50%);
            transition: width 0.3s, height 0.3s, background-color 0.3s;
        }
        .custom-cursor.active {
            width: 50px;
            height: 50px;
            background-color: rgba(0, 123, 255, 0.1);
        }
        @media (max-width: 991px) {
            .custom-cursor { display: none; }
        }
    </style>

    <!-- Vendor CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/vendor/fontawesome.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/plugins/swiper.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/plugins/odometer.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/vendor/animate.min.css') }}">
    
    @if(app()->getLocale() == 'ar')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    @else
        <link rel="stylesheet" href="{{ asset('assets/css/vendor/bootstrap.min.css') }}">
    @endif

    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    
    @if(app()->getLocale() == 'ar')
        <style>
            body { text-align: right; }
            .tmp-mainmenu li.has-dropdown > a::after { margin-right: 5px; margin-left: 0; }
            .header-one .header-content .tmp-mainmenu-nav .tmp-mainmenu > li { margin: 0 15px; }
            .tmp-header-area-start .header-content .tmp-header-right .social-share-wrapper .social-link a { margin-left: 10px; margin-right: 0; }
            
            /* Fix Arabic Letter Separation */
            .text-reveal chars, .split-collab chars, .tmp-title-split chars, .tmp-title-split-2 chars {
                display: inline-block !important;
                white-space: nowrap !important;
            }
            div[class*="split-"] {
                display: inline !important;
            }
        </style>
    @endif

    @stack('styles')
</head>
<body class="home-page">
    <div class="custom-cursor"></div>

    @yield('content')

    <!-- Scripts -->
    <script src="{{ asset('assets/js/vendor/jquery.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/waypoints.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/odometer.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/appear.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/jquery-one-page-nav.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/swiper.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/gsap.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/splittext.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/scrolltigger.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/scrolltoplugins.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/smoothscroll.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/waw.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/isotop.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/animation.js') }}"></script>
    {{-- <script src="{{ asset('assets/js/plugins/contact.form.js') }}"></script> --}}
    <script src="{{ asset('assets/js/vendor/backtop.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/text-type.js') }}"></script>
    <script src="{{ asset('assets/js/main.js') }}"></script>
    <script src="{{ asset('assets/js/custom.js') }}"></script>

    @stack('scripts')
</body>
</html>
