<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\LocaleController;

Route::get('/', function () {
    $services = \App\Models\Service::all();
    $projects = \App\Models\Project::where('is_active', true)->orderBy('order')->latest()->get();
    $blogs = \App\Models\Blog::where('is_active', true)->latest()->take(3)->get();
    $skills = \App\Models\Skill::all();
    $experiences = \App\Models\Experience::orderBy('order')->get();
    $sectors = \App\Models\Sector::where('is_active', true)->orderBy('order')->get();

    return view('welcome', compact('services', 'projects', 'blogs', 'skills', 'experiences', 'sectors'));
});

Route::post('/contact', [\App\Http\Controllers\ContactController::class, 'store'])->name('contact.store')->middleware('throttle:2,1');

Route::get('lang/{locale}', [LocaleController::class, 'set'])->name('lang.set');

// Auth Routes
Route::get('login', [AuthController::class, 'showLogin'])->name('login');
Route::post('login', [AuthController::class, 'login'])->name('login.submit');
Route::post('logout', [AuthController::class, 'logout'])->name('logout');

// Admin Routes
Route::prefix('admin')->name('admin.')->middleware([\App\Http\Middleware\AdminMiddleware::class])->group(function () {
    Route::get('/', function () {
        return view('admin.dashboard');
    })->name('dashboard');

    Route::resource('projects', \App\Http\Controllers\Admin\ProjectController::class);
    Route::resource('blogs', \App\Http\Controllers\Admin\BlogController::class);
    Route::resource('services', \App\Http\Controllers\Admin\ServiceController::class);
    Route::resource('skills', \App\Http\Controllers\Admin\SkillController::class);
    Route::resource('messages', \App\Http\Controllers\Admin\MessageController::class)->only(['index', 'show', 'destroy']);
});
